//: ## ![3DaysOfSwift.com Logo](PageHeader.png) ✅ Swift Study Guide
//: ### Study These Language Features
//: ©️ copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) | [3 Days of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: -------------------
//:
//: ## ✅ Optionals
//:
//: Optionals are enums with two cases:
//:
//: - `some`
//: - `none`
//:
//: Below is a direct replica of Swifts own `Optional` enum.
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:


// re-declaration of the Optional enum declared inside the Swift main library
 enum Optional<T> {
     case some(T)
     case none
 }

// The two cases of the enum
Optional<Int>.some(100)
Optional<Int>.none // nil


// The code below stores two optionals in two variables.
let var1: Optional<Int> = Optional<Int>.some(100)
let var2: Optional<Int> = Optional<Int>.none


//:
//: -------------------
//:
//: ## Short-form Syntax
//:
//: Swift provides a shorter way of writing our code (for optionals).
//:
//: It's called the short-form method.
//:
//: -------------------
//:


// short-form using the ? and nil keywords
let optionalInteger: Int? = nil
let optionalFloat: Float? = nil
let optionalDouble: Double? = nil
let optionalBool: Bool? = nil


//:
//: -------------------
//:
//: ## Long-form Syntax
//:
//: Long-form syntax is the syntax that is more technically correct as it properly uses the Swift rules for specifying our types.
//:
//: -------------------
//:


// long-form exposing the Optional enum code
let longFormSyntax: Optional<Int> = .some(100)
if case Optional.some(let unwrappedValue) = longFormSyntax {
    print(unwrappedValue)
} else {
    print("No value exists")
}


//:
//: -------------------
//:
//: ## Unwrapping the Associated Value
//:
//: -------------------
//:


// Checking if a Value Exists?
let optionalString: String? = "Hello"
if optionalString == nil {
    print("No value exists")
}
if optionalString != nil {
    print("A value exists inside this optional")
}

// unwrapping values inside optionals
let wrappedValue: String? = "John Appleseed"
if let value = wrappedValue {
    print("The value is now unwrapped and usable. The value is \(value)")
} else {
    print("No value exists")
}


//:
//: -------------------
//: 
//: [3DaysOfSwift.com](https://www.3DaysOfSwift.com) | [Email Us](mailto:helloworld@3daysofswift.com?subject=Hello)
//:
//: Ready to start learning Swift? [Yes ✅](https://www.3DaysOfSwift.com)
//:
//: -------------------
//:
//: [◀  Previous Page](@previous)  |  [Next Page  ▶](@next)
//:
//: -------------------
//:
//: ![3 Days Of Swift Logo](Footer.png) [Website](https://www.3DaysOfSwift.com) | [3 Days Of Swift Bootcamp](https://www.3DaysOfSwift.com/bootcamp) | [Interview Prep](https://www.3DaysOfSwift.com/interview-prep)
//:
//: © Copyright of [3DaysOfSwift.com](https://www.3DaysOfSwift.com). All rights reserved. Don't forget - come back when you've got an [interview](https://www.3DaysOfSwift.com/interview-prep)!
//:
//: Welcome to our community of [3DaysOfSwift.com](https://www.3DaysOfSwift.com) developers!
//:
//: 🧕🏻🙋🏽‍♂️👨🏿‍💼👩🏼‍💼👩🏻‍💻💁🏼‍♀️👨🏼‍💼🙋🏻‍♂️🙋🏻‍♀️👩🏼‍💻🙋🏿💁🏽‍♂️🙋🏽‍♀️🙋🏿‍♀️🧕🏾🙋🏼‍♂️
//:
